<?php
/*
Plugin Name: Pdee Jobs
Description: Post and display jobs with a shortcode.
Version: 1.0
Author: Pdee
*/

// -----------------------------------------------------------------------------
// 1. Custom Post Type
// -----------------------------------------------------------------------------
function pdee_register_jobs_cpt() {
    register_post_type( 'pdee_jobs', array(
        'labels' => array(
            'name'          => 'Pdee Jobs',
            'singular_name' => 'Pdee Job',
            'add_new_item'  => 'Add New Job',
            'edit_item'     => 'Edit Job',
        ),
        'public'       => true,
        'has_archive'  => true,
        'rewrite'      => array( 'slug' => 'jobs' ),
        'menu_icon'    => 'dashicons-id',
        'supports'     => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail' ),
    ) );
}
add_action( 'init', 'pdee_register_jobs_cpt' );

// -----------------------------------------------------------------------------
// 2. Meta-box: Short Description & Job URL
// -----------------------------------------------------------------------------
add_action( 'add_meta_boxes', function () {
    add_meta_box(
        'pdee_job_meta',
        'Job Details',
        'pdee_job_meta_box_html',
        'pdee_jobs',
        'normal',
        'default'
    );
} );

function pdee_job_meta_box_html( $post ) {
    $short_desc = get_post_meta( $post->ID, 'pdee_short_desc', true );
    $job_url    = get_post_meta( $post->ID, 'pdee_job_url',  true );
    ?>
    <p>
        <label for="pdee_short_desc"><strong>Short Description</strong></label><br>
        <textarea id="pdee_short_desc" name="pdee_short_desc" rows="3" style="width:100%;"><?php
            echo esc_textarea( $short_desc );
        ?></textarea>
    </p>
    <p>
        <label for="pdee_job_url"><strong>Job Apply URL</strong></label><br>
        <input id="pdee_job_url" name="pdee_job_url" type="url" value="<?php echo esc_url( $job_url ); ?>" style="width:100%;">
    </p>
    <?php
}

// Save meta
add_action( 'save_post_pdee_jobs', function ( $post_id ) {
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
    if ( isset( $_POST['pdee_short_desc'] ) ) {
        update_post_meta( $post_id, 'pdee_short_desc', sanitize_textarea_field( $_POST['pdee_short_desc'] ) );
    }
    if ( isset( $_POST['pdee_job_url'] ) ) {
        update_post_meta( $post_id, 'pdee_job_url', esc_url_raw( $_POST['pdee_job_url'] ) );
    }
} );

// -----------------------------------------------------------------------------
// 3. Front-end Shortcode
// -----------------------------------------------------------------------------
add_shortcode( 'pdee_jobs', 'pdee_jobs_shortcode' );
function pdee_jobs_shortcode( $atts = array() ) {
    ob_start();

    // Styles (printed once)
    static $printed = false;
    if ( ! $printed ) {
        ?>
        <style>
            .pdee-jobs        { display:flex; flex-direction:column; gap:25px; }
            .pdee-job         { border:2px solid #ddd; border-radius:8px; padding:20px; background:#fafafa; }
            .pdee-job h3      { margin:0 0 8px; font-size:22px; }
            .pdee-job-date    { font-size:14px; color:#777; margin-top:12px; }
            .pdee-job-btn     { display:inline-block; background:#0073aa; color:#fff; padding:8px 18px;
                                border-radius:4px; text-decoration:none; font-weight:600; margin-top:10px; }
            .pdee-job-btn:hover { background:#005077; }
        </style>
        <?php
        $printed = true;
    }

    // Query newest first
    $jobs = new WP_Query( array(
        'post_type'      => 'pdee_jobs',
        'posts_per_page' => -1,
        'orderby'        => 'date',
        'order'          => 'DESC',
    ) );

    if ( $jobs->have_posts() ) {
        echo '<div class="pdee-jobs">';
        while ( $jobs->have_posts() ) {
            $jobs->the_post();
            $short_desc = get_post_meta( get_the_ID(), 'pdee_short_desc', true );
            $job_url    = get_post_meta( get_the_ID(), 'pdee_job_url',  true );
            ?>
            <div class="pdee-job">
                <h3><a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title(); ?></a></h3>
                <?php if ( $short_desc ) : ?>
                    <p><?php echo esc_html( $short_desc ); ?></p>
                <?php endif; ?>

                <?php if ( $job_url ) : ?>
                    <a class="pdee-job-btn" href="<?php echo esc_url( $job_url ); ?>" target="_blank">Apply</a>
                <?php endif; ?>

                <div class="pdee-job-date">Posted on <?php echo esc_html( get_the_date() ); ?></div>
            </div>
            <?php
        }
        echo '</div>';
    }

    wp_reset_postdata();
    return ob_get_clean();
}
